/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.debug;

import java.util.HashSet;
import java.util.Set;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import processing.app.Messages;
import processing.mode.java.debug.LineHighlight;

public class LineID
implements DocumentListener {
    protected String fileName;
    protected int lineIdx;
    protected Document doc;
    protected Position pos;
    protected Set<LineHighlight> listeners = new HashSet<LineHighlight>();

    public LineID(String fileName, int lineIdx) {
        this.fileName = fileName;
        this.lineIdx = lineIdx;
    }

    public String fileName() {
        return this.fileName;
    }

    public synchronized int lineIdx() {
        return this.lineIdx;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LineID other = (LineID)obj;
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        return this.lineIdx == other.lineIdx;
    }

    public String toString() {
        return String.valueOf(this.fileName) + ":" + (this.lineIdx + 1);
    }

    public synchronized void startTracking(Document doc) {
        if (doc == null) {
            return;
        }
        if (doc == this.doc) {
            return;
        }
        try {
            Element line = doc.getDefaultRootElement().getElement(this.lineIdx);
            if (line == null) {
                return;
            }
            String lineText = doc.getText(line.getStartOffset(), line.getEndOffset() - line.getStartOffset());
            this.pos = doc.createPosition(line.getStartOffset() + LineID.nonWhiteSpaceOffset(lineText));
            this.doc = doc;
            doc.addDocumentListener(this);
        }
        catch (BadLocationException ex) {
            Messages.loge(null, (Throwable)ex);
            this.pos = null;
            this.doc = null;
        }
    }

    public synchronized void stopTracking() {
        if (this.doc != null) {
            this.doc.removeDocumentListener(this);
            this.doc = null;
        }
    }

    protected synchronized void updatePosition() {
        if (this.doc != null && this.pos != null) {
            int offset = this.pos.getOffset();
            int oldLineIdx = this.lineIdx;
            this.lineIdx = this.doc.getDefaultRootElement().getElementIndex(offset);
            if (this.lineIdx != oldLineIdx) {
                for (LineHighlight l : this.listeners) {
                    if (l != null) {
                        l.lineChanged(this, oldLineIdx, this.lineIdx);
                        continue;
                    }
                    this.listeners.remove(l);
                }
            }
        }
    }

    public void addListener(LineHighlight l) {
        this.listeners.add(l);
    }

    public void removeListener(LineHighlight l) {
        this.listeners.remove(l);
    }

    protected static int nonWhiteSpaceOffset(String str) {
        int i = 0;
        while (i < str.length()) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return i;
            }
            ++i;
        }
        return str.length() - 1;
    }

    protected void editEvent(DocumentEvent de) {
        if (de.getOffset() <= this.pos.getOffset()) {
            this.updatePosition();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        this.editEvent(de);
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        this.editEvent(de);
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
    }
}

