/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.debug;

import java.util.HashSet;
import java.util.Set;
import processing.mode.java.JavaEditor;
import processing.mode.java.debug.LineID;

public class LineHighlight {
    protected final JavaEditor editor;
    protected final LineID lineID;
    protected String marker;
    protected int priority = 0;
    protected static final Set<LineHighlight> allHighlights = new HashSet<LineHighlight>();

    public LineHighlight(LineID lineID, JavaEditor editor) {
        this.lineID = lineID;
        this.editor = editor;
        lineID.addListener(this);
        lineID.startTracking(editor.getTab(lineID.fileName()).getDocument());
        this.paint();
        allHighlights.add(this);
    }

    protected static boolean isHighestPriority(LineHighlight hl) {
        for (LineHighlight check : allHighlights) {
            if (!check.getLineID().equals(hl.getLineID()) || check.priority() <= hl.priority()) continue;
            return false;
        }
        return true;
    }

    public void setPriority(int p) {
        this.priority = p;
    }

    public int priority() {
        return this.priority;
    }

    public LineHighlight(int lineIdx, JavaEditor editor) {
        this(editor.getLineIDInCurrentTab(lineIdx), editor);
    }

    public void setMarker(String marker) {
        this.marker = marker;
        this.paint();
    }

    public LineID getLineID() {
        return this.lineID;
    }

    public boolean isOnLine(LineID testLine) {
        return this.lineID.equals(testLine);
    }

    public void lineChanged(LineID line, int oldLineIdx, int newLineIdx) {
        if (this.editor.isInCurrentTab(new LineID(line.fileName(), oldLineIdx))) {
            this.editor.getJavaTextArea().clearGutterText(oldLineIdx);
        }
        if (LineHighlight.isHighestPriority(this)) {
            this.paint();
        }
    }

    public void dispose() {
        this.lineID.removeListener(this);
        this.lineID.stopTracking();
        allHighlights.remove(this);
    }

    public void paint() {
        if (this.editor.isInCurrentTab(this.lineID) && this.marker != null) {
            this.editor.getJavaTextArea().setGutterText(this.lineID.lineIdx(), this.marker);
        }
    }

    public void clear() {
        if (this.editor.isInCurrentTab(this.lineID)) {
            this.editor.getJavaTextArea().clearGutterText(this.lineID.lineIdx());
        }
    }
}

