/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import processing.app.Base;
import processing.app.Library;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.RunnerListener;
import processing.app.Sketch;
import processing.app.SketchException;
import processing.app.ui.Editor;
import processing.app.ui.EditorException;
import processing.app.ui.EditorState;
import processing.mode.java.JavaBuild;
import processing.mode.java.JavaEditor;
import processing.mode.java.runner.Runner;
import processing.mode.java.tweak.SketchParser;

public class JavaMode
extends Mode {
    public static volatile boolean errorCheckEnabled = true;
    public static volatile boolean warningsEnabled = true;
    public static volatile boolean codeCompletionsEnabled = true;
    public static volatile boolean debugOutputEnabled = false;
    public static volatile boolean errorLogsEnabled = false;
    public static volatile boolean autoSaveEnabled = true;
    public static volatile boolean autoSavePromptEnabled = true;
    public static volatile boolean defaultAutoSaveEnabled = true;
    public static volatile boolean ccTriggerEnabled = false;
    public static volatile boolean importSuggestEnabled = true;
    public static volatile boolean inspectModeHotkeyEnabled = true;
    public static int autoSaveInterval = 3;
    public static volatile int codeCompletionTriggerLength = 1;
    public static final String prefErrorCheck = "pdex.errorCheckEnabled";
    public static final String prefWarnings = "pdex.warningsEnabled";
    public static final String prefDebugOP = "pdex.dbgOutput";
    public static final String prefErrorLogs = "pdex.writeErrorLogs";
    public static final String prefAutoSaveInterval = "pdex.autoSaveInterval";
    public static final String prefAutoSave = "pdex.autoSave.autoSaveEnabled";
    public static final String prefAutoSavePrompt = "pdex.autoSave.promptDisplay";
    public static final String prefDefaultAutoSave = "pdex.autoSave.autoSaveByDefault";
    public static final String suggestionsFileName = "suggestions.txt";
    public static final String COMPLETION_PREF = "pdex.completion";
    public static final String COMPLETION_TRIGGER_PREF = "pdex.completion.trigger";
    public static final String SUGGEST_IMPORTS_PREF = "pdex.suggest.imports";
    public static final String INSPECT_MODE_HOTKEY_PREF = "pdex.inspectMode.hotkey";
    public static final Map<String, Set<String>> suggestionsMap = new HashMap<String, Set<String>>();

    public Editor createEditor(Base base, String path, EditorState state) throws EditorException {
        return new JavaEditor(base, path, state, this);
    }

    public JavaMode(Base base, File folder) {
        super(base, folder);
        this.loadPreferences();
    }

    public String getTitle() {
        return "Java";
    }

    public File[] getExampleCategoryFolders() {
        return new File[]{new File(this.examplesFolder, "Basics"), new File(this.examplesFolder, "Topics"), new File(this.examplesFolder, "Demos"), new File(this.examplesFolder, "Books")};
    }

    public String getDefaultExtension() {
        return "pde";
    }

    public String[] getExtensions() {
        return new String[]{"pde", "java"};
    }

    public String[] getIgnorable() {
        return new String[]{"applet", "application.macosx", "application.windows", "application.linux"};
    }

    public Library getCoreLibrary() {
        if (this.coreLibrary == null) {
            File coreFolder = Platform.getContentFile((String)"core");
            this.coreLibrary = new Library(coreFolder);
        }
        return this.coreLibrary;
    }

    public Runner handleLaunch(Sketch sketch, RunnerListener listener, final boolean present) throws SketchException {
        JavaBuild build = new JavaBuild(sketch);
        String appletClassName = build.build(true);
        if (appletClassName != null) {
            final Runner runtime = new Runner(build, listener);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (present) {
                        runtime.present(null);
                    } else {
                        runtime.launch(null);
                    }
                }
            }).start();
            return runtime;
        }
        return null;
    }

    public Runner handleTweak(Sketch sketch, RunnerListener listener) throws SketchException {
        final JavaEditor editor = (JavaEditor)listener;
        JavaBuild build = new JavaBuild(sketch);
        String appletClassName = build.build(true);
        if (appletClassName == null) {
            return null;
        }
        editor.initBaseCode();
        boolean requiresTweak = SketchParser.containsTweakComment(editor.baseCode);
        final SketchParser parser = new SketchParser(editor.baseCode, requiresTweak);
        final boolean launchInteractive = editor.automateSketch(sketch, parser);
        build = new JavaBuild(sketch);
        appletClassName = build.build(false);
        if (appletClassName != null) {
            final Runner runtime = new Runner(build, listener);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    runtime.launch(null);
                    if (launchInteractive) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                editor.initEditorCode(parser.allHandles, false);
                                editor.stopTweakMode(parser.allHandles);
                            }
                        });
                    }
                }
            }).start();
            if (launchInteractive) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        editor.initEditorCode(parser.allHandles, false);
                        editor.updateInterface(parser.allHandles, parser.colorBoxes);
                        editor.startTweakMode();
                    }
                });
            }
            return runtime;
        }
        return null;
    }

    public boolean handleExportApplication(Sketch sketch) throws SketchException, IOException {
        JavaBuild build = new JavaBuild(sketch);
        return build.exportApplication();
    }

    public String getSearchPath() {
        return this.getCoreLibrary().getJarPath();
    }

    public void loadPreferences() {
        Messages.log((String)"Load PDEX prefs");
        this.ensurePrefsExist();
        errorCheckEnabled = Preferences.getBoolean((String)prefErrorCheck);
        warningsEnabled = Preferences.getBoolean((String)prefWarnings);
        codeCompletionsEnabled = Preferences.getBoolean((String)COMPLETION_PREF);
        errorLogsEnabled = Preferences.getBoolean((String)prefErrorLogs);
        autoSaveInterval = Preferences.getInteger((String)prefAutoSaveInterval);
        autoSaveEnabled = Preferences.getBoolean((String)prefAutoSave);
        autoSavePromptEnabled = Preferences.getBoolean((String)prefAutoSavePrompt);
        defaultAutoSaveEnabled = Preferences.getBoolean((String)prefDefaultAutoSave);
        ccTriggerEnabled = Preferences.getBoolean((String)COMPLETION_TRIGGER_PREF);
        importSuggestEnabled = Preferences.getBoolean((String)SUGGEST_IMPORTS_PREF);
        inspectModeHotkeyEnabled = Preferences.getBoolean((String)INSPECT_MODE_HOTKEY_PREF);
        this.loadSuggestionsMap();
    }

    public void savePreferences() {
        Messages.log((String)"Saving PDEX prefs");
        Preferences.setBoolean((String)prefErrorCheck, (boolean)errorCheckEnabled);
        Preferences.setBoolean((String)prefWarnings, (boolean)warningsEnabled);
        Preferences.setBoolean((String)COMPLETION_PREF, (boolean)codeCompletionsEnabled);
        Preferences.setBoolean((String)prefErrorLogs, (boolean)errorLogsEnabled);
        Preferences.setInteger((String)prefAutoSaveInterval, (int)autoSaveInterval);
        Preferences.setBoolean((String)prefAutoSave, (boolean)autoSaveEnabled);
        Preferences.setBoolean((String)prefAutoSavePrompt, (boolean)autoSavePromptEnabled);
        Preferences.setBoolean((String)prefDefaultAutoSave, (boolean)defaultAutoSaveEnabled);
        Preferences.setBoolean((String)COMPLETION_TRIGGER_PREF, (boolean)ccTriggerEnabled);
        Preferences.setBoolean((String)SUGGEST_IMPORTS_PREF, (boolean)importSuggestEnabled);
        Preferences.setBoolean((String)INSPECT_MODE_HOTKEY_PREF, (boolean)inspectModeHotkeyEnabled);
    }

    public void loadSuggestionsMap() {
        File suggestionsListFile = new File(this.getFolder() + File.separator + suggestionsFileName);
        if (!suggestionsListFile.exists()) {
            Messages.loge((String)("Suggestions file not found! " + suggestionsListFile.getAbsolutePath()));
            return;
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(suggestionsListFile));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || !line.contains("=")) continue;
                String key = line.split("=")[0];
                String val = line.split("=")[1];
                if (suggestionsMap.containsKey(key)) {
                    suggestionsMap.get(key).add(val);
                    continue;
                }
                HashSet<String> set = new HashSet<String>();
                set.add(val);
                suggestionsMap.put(key, set);
            }
            br.close();
        }
        catch (IOException iOException) {
            Messages.loge((String)("IOException while reading suggestions file:" + suggestionsListFile.getAbsolutePath()));
        }
    }

    public void ensurePrefsExist() {
        if (Preferences.get((String)prefErrorCheck) == null) {
            Preferences.setBoolean((String)prefErrorCheck, (boolean)errorCheckEnabled);
        }
        if (Preferences.get((String)prefWarnings) == null) {
            Preferences.setBoolean((String)prefWarnings, (boolean)warningsEnabled);
        }
        if (Preferences.get((String)COMPLETION_PREF) == null) {
            Preferences.setBoolean((String)COMPLETION_PREF, (boolean)codeCompletionsEnabled);
        }
        if (Preferences.get((String)prefDebugOP) == null && Preferences.get((String)prefErrorLogs) == null) {
            Preferences.setBoolean((String)prefErrorLogs, (boolean)errorLogsEnabled);
        }
        if (Preferences.get((String)prefAutoSaveInterval) == null) {
            Preferences.setInteger((String)prefAutoSaveInterval, (int)autoSaveInterval);
        }
        if (Preferences.get((String)prefAutoSave) == null) {
            Preferences.setBoolean((String)prefAutoSave, (boolean)autoSaveEnabled);
        }
        if (Preferences.get((String)prefAutoSavePrompt) == null) {
            Preferences.setBoolean((String)prefAutoSavePrompt, (boolean)autoSavePromptEnabled);
        }
        if (Preferences.get((String)prefDefaultAutoSave) == null) {
            Preferences.setBoolean((String)prefDefaultAutoSave, (boolean)defaultAutoSaveEnabled);
        }
        if (Preferences.get((String)COMPLETION_TRIGGER_PREF) == null) {
            Preferences.setBoolean((String)COMPLETION_TRIGGER_PREF, (boolean)ccTriggerEnabled);
        }
        if (Preferences.get((String)SUGGEST_IMPORTS_PREF) == null) {
            Preferences.setBoolean((String)SUGGEST_IMPORTS_PREF, (boolean)importSuggestEnabled);
        }
        if (Preferences.get((String)INSPECT_MODE_HOTKEY_PREF) == null) {
            Preferences.setBoolean((String)INSPECT_MODE_HOTKEY_PREF, (boolean)inspectModeHotkeyEnabled);
        }
    }

    public static void main(String[] args) {
        Base.main((String[])args);
    }
}

