/*
 * Decompiled with CFR 0.152.
 */
package processing.net;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import processing.core.PApplet;
import processing.net.Client;

public class Server
implements Runnable {
    PApplet parent;
    Method serverEventMethod;
    Thread thread;
    ServerSocket server;
    int port;
    public int clientCount;
    public Client[] clients;
    int lastAvailable = -1;

    public Server(PApplet pApplet, int n) {
        this(pApplet, n, null);
    }

    public Server(PApplet pApplet, int n, String string) {
        this.parent = pApplet;
        this.port = n;
        try {
            this.server = string == null ? new ServerSocket(this.port) : new ServerSocket(this.port, 10, InetAddress.getByName(string));
            this.clients = new Client[10];
            this.thread = new Thread(this);
            this.thread.start();
            pApplet.registerMethod("dispose", (Object)this);
            try {
                this.serverEventMethod = pApplet.getClass().getMethod("serverEvent", Server.class, Client.class);
            }
            catch (Exception exception) {}
        }
        catch (IOException iOException) {
            this.thread = null;
            throw new RuntimeException(iOException);
        }
    }

    public void disconnect(Client client) {
        client.stop();
        int n = this.clientIndex(client);
        if (n != -1) {
            this.removeIndex(n);
        }
    }

    protected void removeIndex(int n) {
        --this.clientCount;
        int n2 = n;
        while (n2 < this.clientCount) {
            this.clients[n2] = this.clients[n2 + 1];
            ++n2;
        }
        this.clients[this.clientCount] = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnectAll() {
        Client[] clientArray = this.clients;
        synchronized (this.clients) {
            int n = 0;
            while (n < this.clientCount) {
                try {
                    this.clients[n].stop();
                }
                catch (Exception exception) {}
                this.clients[n] = null;
                ++n;
            }
            this.clientCount = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void addClient(Client client) {
        if (this.clientCount == this.clients.length) {
            this.clients = (Client[])PApplet.expand((Object)this.clients);
        }
        this.clients[this.clientCount++] = client;
    }

    protected int clientIndex(Client client) {
        int n = 0;
        while (n < this.clientCount) {
            if (this.clients[n] == client) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean active() {
        return this.thread != null;
    }

    public static String ip() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client available() {
        Client[] clientArray = this.clients;
        synchronized (this.clients) {
            int n = this.lastAvailable + 1;
            if (n >= this.clientCount) {
                n = 0;
            }
            int n2 = 0;
            while (n2 < this.clientCount) {
                int n3 = (n + n2) % this.clientCount;
                Client client = this.clients[n3];
                if (!client.active()) {
                    this.removeIndex(n3);
                    --n2;
                    --n3;
                }
                if (client.available() > 0) {
                    this.lastAvailable = n3;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return client;
                }
                ++n2;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    public void stop() {
        this.dispose();
    }

    public void dispose() {
        this.thread = null;
        if (this.clients != null) {
            this.disconnectAll();
            this.clientCount = 0;
            this.clients = null;
        }
        try {
            if (this.server != null) {
                this.server.close();
                this.server = null;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (Thread.currentThread() == this.thread) {
            try {
                Socket socket = this.server.accept();
                Client client = new Client(this.parent, socket);
                Client[] clientArray = this.clients;
                // MONITORENTER : this.clients
                this.addClient(client);
                if (this.serverEventMethod != null) {
                    try {
                        this.serverEventMethod.invoke((Object)this.parent, this, client);
                    }
                    catch (Exception exception) {
                        System.err.println("Disabling serverEvent() for port " + this.port);
                        exception.printStackTrace();
                        this.serverEventMethod = null;
                    }
                }
                // MONITOREXIT : clientArray
            }
            catch (SocketException socketException) {
                System.err.println("Server SocketException: " + socketException.getMessage());
                this.thread = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.thread = null;
            }
            try {
                Thread.sleep(8L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void write(int n) {
        int n2 = 0;
        while (n2 < this.clientCount) {
            if (this.clients[n2].active()) {
                this.clients[n2].write(n);
                ++n2;
                continue;
            }
            this.removeIndex(n2);
        }
    }

    public void write(byte[] byArray) {
        int n = 0;
        while (n < this.clientCount) {
            if (this.clients[n].active()) {
                this.clients[n].write(byArray);
                ++n;
                continue;
            }
            this.removeIndex(n);
        }
    }

    public void write(String string) {
        int n = 0;
        while (n < this.clientCount) {
            if (this.clients[n].active()) {
                this.clients[n].write(string);
                ++n;
                continue;
            }
            this.removeIndex(n);
        }
    }
}

